﻿/* --------------------------------------------------------------------------------
 *  <copyright file="Program.cs" company="Hybrid Software Helix Ltd">
 *    Copyright (c) 2025 Hybrid Software Helix Ltd. All rights reserved.
 *  </copyright>
 *  <summary>
 *    This example is provided on an "as is" basis and without warranty of any kind.
 *    Hybrid Software Helix Ltd. does not warrant or make any representations
 *    regarding the use or results of use of this example.
 *  </summary>
 * ---------------------------------------------------------------------------------
 */

using JawsMako;
using static JawsMako.jawsmakoIF_csharp;

namespace EncodePNGinMemory;

internal class Program
{
    static int Main(string[] args)
    {
        try
        {
            var testFilepath = @"..\..\..\..\TestFiles\";

            var mako = IJawsMako.create();
            IJawsMako.enableAllFeatures(mako);

            // Input
            var pdfInput = IPDFInput.create(mako);
            using var assembly = pdfInput.open(testFilepath + "Cheshire Cat.pdf");
            using var inFixedPage = assembly.getDocument().getPage()
                .getContent();

            // TODO


            IPDFOutput.create(mako).writeAssembly(assembly, IOutputStream.createToFile(mako, "test.pdf"));
        }
        catch (MakoException e)
        {
            Console.WriteLine($"Exception thrown: {e.m_errorCode}: {e.m_msg}");
        }
        catch (Exception e)
        {
            Console.WriteLine($"Exception thrown: {e}");
        }

        return 0;
    }
}